/*
 show  //正常状态的框
 bigshow   // 放大的框的盒子
 smallshow  //缩小版的框
 mask   //放大的区域（黑色遮罩）
 bigitem  //放大的框

 */
//        var obj = new mag('.show', '.bigshow','.smallshow','.mask','.bigitem');
//        obj.init()
function mag (show, bigshow, smallshow, mask, bigitem) {
  this.show = show;
  this.bigshow = bigshow;
  this.smallshow = smallshow;
  this.mask = mask;
  this.bigitem = bigitem;
  this.obj = {
    prev: '.prev',
    next: '.next',
    middle: '.middle',
    middleBox: '.middle_box'
  }
}
mag.prototype = {
  init: function() {
    var that = this;
    that.start();
    this.showHover();
    this.smallImgHover();
    this.showMove();
    this.prevClick();
    this.nextClick();
  },
  start: function() {
    var that = this;
    var buil = jQuery(that.show).width() / jQuery(that.mask).width() * jQuery(that.bigshow).width();
    jQuery(that.bigitem).css("width", buil);

    jQuery(that.smallshow + ' img').eq(0).css("border", "1px solid #f40");

    var midhei = jQuery(that.obj.middle + ' li').innerWidth() * jQuery(that.obj.middle + ' li').length;
    jQuery(that.obj.middle).width(midhei);

  },
  showHover: function() {
    var that = this;
    jQuery(that.show).hover(function() {
      jQuery(that.bigshow).show();
      jQuery(that.mask).show();
    }, function() {
      jQuery(that.bigshow).hide();
      jQuery(that.mask).hide();
    });
  },
  smallImgHover: function() {
    var that = this;
    jQuery(that.smallshow + ' img').click(function() {
      var src = jQuery(this).attr("src");
      jQuery(that.smallshow + ' img').css("border", "1px solid #e8e8e8");
      jQuery(this).css("border", "1px solid #f40");
      jQuery(that.show + '>img').attr("src", src);
      jQuery(that.bigitem + '>img').attr("src", src);
    });
  },
  showMove: function() {
    var that = this;
    jQuery(that.show).mousemove(function(e) {
      var bigx = jQuery(this).offset().left;
      var bigy = jQuery(this).offset().top;
      var x = e.clientX;
      var y = e.clientY;
      var scrollx = jQuery(window).scrollLeft();
      var scrolly = jQuery(window).scrollTop();
      var ox = x + scrollx - bigx - jQuery(that.mask).width() / 2;
      var oy = y + scrolly - bigy - jQuery(that.mask).height() / 2;
      if (ox <= 0) {
        ox = 0
      }
      if (ox > jQuery(that.show).width() - jQuery(that.mask).width()) {
        ox = jQuery(that.show).width() - jQuery(that.mask).width();
      }
      if (oy <= 0) {
        oy = 0
      }
      if (oy > jQuery(that.show).height() - jQuery(that.mask).height()) {
        oy = jQuery(that.show).height() - jQuery(that.mask).height();
      }
      jQuery(that.mask).css({ left: ox });
      jQuery(that.mask).css({ top: oy });
      var bei = jQuery(that.show).width() / jQuery(that.mask).width();
      jQuery(that.bigitem + '>img').css(
        {
          marginLeft: -bei * ox,
          marginTop: -bei * oy
        })
    });
  },
  prevClick: function() {
    var that = this;
    jQuery(that.obj.prev).click(function() {
      if (jQuery(that.obj.middle).width() - jQuery(that.obj.middleBox).width() > 0) {
        if (Math.abs(parseInt(jQuery(that.obj.middle).css("marginLeft"))) > jQuery(that.obj.middleBox).width()) {
          jQuery(that.obj.middle).css("marginLeft", parseInt(jQuery(that.obj.middle).css("marginLeft")) + jQuery(that.obj.middleBox).width())
        }
        if (Math.abs(parseInt(jQuery(that.obj.middle).css("marginLeft"))) < jQuery(that.obj.middleBox).width()) {
          jQuery(that.obj.middle).css("marginLeft", "0px");
          jQuery(that.obj.next).removeClass("nextnone");
          jQuery(that.obj.prev).addClass("prevnone");
        }
      } else {
        return;
      }
    });
  },
  nextClick: function() {
 
    var that = this;
    jQuery(that.obj.next).click(function() {
   
      if (jQuery(that.obj.middle).width() - jQuery(that.obj.middleBox).width() > 0) {
        var shuzi = jQuery(that.obj.middle).width() - Math.abs(parseInt(jQuery(that.obj.middle).css("marginLeft"))) - jQuery(that.obj.middleBox).width();
        if (shuzi > jQuery(that.obj.middleBox).width()) {
          jQuery(that.obj.middle).css("marginLeft", -jQuery(that.obj.middleBox).width() + parseInt(jQuery(that.obj.middle).css("marginLeft")))
        }
        if (shuzi < jQuery(that.obj.middleBox).width()) {
          jQuery(that.obj.middle).css("marginLeft", -(jQuery(that.obj.middle).width() - jQuery(that.obj.middleBox).width()))
          jQuery(that.obj.next).addClass("nextnone");
          jQuery(that.obj.prev).removeClass("prevnone");
        }
      } else {
        return;
      }

    });
  }

}




