<?php
/**

* Author url: http://aiwangxue.com
* Version: 6.5
**/

class ashuwp_options_feild extends ashuwp_framework_core {

  private $options;
  private $old_value;
  private $pageinfo;
  private $saved_optionname;
  private $is_network;
  
  function __construct($ashu_option_conf, $pageinfo) {
    
    $this->options = $ashu_option_conf;
    $this->pageinfo = $pageinfo;
    $this->saved_optionname = 'ashuwp_'.$this->pageinfo['optionname'];
    if( isset($this->pageinfo['network']) && is_multisite() && $this->pageinfo['network']==true ){
      $this->is_network = true;
    }else{
      $this->is_network = false;
    }
    
    add_action( $this->is_network ? 'network_admin_menu' : 'admin_menu', array(&$this, 'add_admin_menu') );
	
    if( isset($_GET['page']) && ($_GET['page'] == $this->pageinfo['filename']) ) {
      add_action('admin_enqueue_scripts', array(&$this, 'enqueue_css_js'));
      add_action( 'admin_footer', array(&$this, 'enqueue_html') );
    }
  }
  
  function add_admin_menu() {
    if($this->pageinfo['child']) {
      $parent_slug = $this->pageinfo['parent_slug'];
      add_submenu_page($parent_slug, $this->pageinfo['full_name'], $this->pageinfo['full_name'], 'manage_options', $this->pageinfo['filename'], array(&$this, 'initialize'));
    }else{
      add_menu_page($this->pageinfo['full_name'], $this->pageinfo['full_name'], 'manage_options', $this->pageinfo['filename'], array(&$this, 'initialize'),'',26);
    }
  }
  
  function make_data_available() {
    if( $this->is_network ){
      $this->old_value[$this->pageinfo['optionname']] = get_site_option( $this->saved_optionname );
    }else{
      $this->old_value[$this->pageinfo['optionname']] = get_option($this->saved_optionname);
    }
    $this->old_value = $this->htmlspecialchars_deep($this->old_value,ENT_QUOTES,'UTF-8');
    
    foreach ($this->options as $key => $option) {
      
      if( isset($option['id']) && isset($this->old_value[$this->pageinfo['optionname']][$option['id']])){
        $this->options[$key]['std'] = $this->old_value[$this->pageinfo['optionname']][$option['id']];
      }
    }
    
  }
  
  function htmlspecialchars_deep ($mixed, $quote_style=ENT_QUOTES, $charset='UTF-8') {
    if (is_array($mixed)) {
      foreach ($mixed as $key => $value) {
        $mixed[$key] = $this->htmlspecialchars_deep($value, $quote_style, $charset);
      }
    } elseif (is_string($mixed)) {
      $mixed = htmlspecialchars_decode($mixed, $quote_style);
    }
    return $mixed;
  }

  function initialize() {
    $this->get_save_options();
    $this->make_data_available();
    $this->display();
  }
  
  function display() {
    $saveoption = false;
    echo '<div class="wrap">';
    echo '<h1 class="wp-heading-inline">'.$this->pageinfo['full_name'].'</h1>';
    if(!empty($this->pageinfo['desc'])){
      echo '<span class="page_desc">'.$this->pageinfo['desc'].'</span>';
    }
    echo '<form method="post" action="">';
    echo '<div class="tab-content ashuwp_feild_tabs clearfix">';
    $this->tab_toggle($this->options);
    
    foreach ($this->options as $option) {
      if( ( $option['type']=='open' || $option['type']=='close' || $option['type']=='title') || ( isset($option['id']) && method_exists($this, $option['type']) ) ) {
        
        if( !isset($option['std']) )
          $option['std'] = '';
        
        if( in_array($option['type'],array('text','textarea',)) && ( !empty($option['multiple']) && $option['multiple']==false ) )
          $option['std'] = htmlspecialchars($option['std'],ENT_COMPAT, 'UTF-8');
        
        $this->{$option['type']}($option);
        $saveoption = true;
      }
    }
    
    if($saveoption) {
      echo '<script src="'.get_template_directory_uri().'/admin/js/ashuwp_frameft.js"></script><div class="ashuwp_field"><div class="ashuwp_field_area">';
      wp_nonce_field( 'ashuwp_framework_action','ashuwp_framework_field' );
      echo '<input type="submit" name="ashuwp_framework_submit" class="button-primary autowidth" value="保存设置" /><input type="submit" name="ashuwp_framework_reset" class="button-secondary autowidth" value="清空设置" /></div></div>';
    }
    
    echo '</div></form></div>';
  }
  
  function get_save_options() {
    
    $newoptions  = $this->old_value;
    
    if( isset($_REQUEST['ashuwp_framework_field']) && check_admin_referer('ashuwp_framework_action', 'ashuwp_framework_field') ) {
      
      if(!empty($_POST['ashuwp_framework_reset'])){
        echo '<div class="updated fade" id="message" style=""><p><strong>Option reseted.</strong></p></div>';
        
        if( $this->is_network ){
          delete_site_option( $this->saved_optionname );
        }else{
          delete_option( $this->saved_optionname );
        }
        
      }
      
      if(!empty($_POST['ashuwp_framework_submit'])){
        echo '<div class="updated fade" id="message" style=""><p><strong>保存成功！</strong></p></div>';
        
        foreach($this->options as $option) {
          
          if( $option['type'] == 'tinymce' ){
            $value = stripslashes( $_POST[$option['id']] );
            $newoptions[$option['id']] = $value;
          }elseif( ( !empty($option['multiple']) && $option['multiple']===true ) || $option['type'] == 'group' ){
            if( !empty($_POST[$option['id']]) ){
              $value = $_POST[$option['id']];
            }else{
              $value = '';
            }
            $newoptions[$option['id']] = $value;
            
          }elseif( in_array( $option['type'], array('text','textarea') ) ){
            $value = stripslashes( $_POST[$option['id']] );
            $value = htmlspecialchars($value,ENT_COMPAT, 'UTF-8');
            $newoptions[$option['id']] = $value;
          }elseif($option['type'] == 'checkbox'){
            $newoptions[$option['id']] = empty($_POST[$option['id']]) ? array(): $_POST[$option['id']];
          }elseif( $option['type'] == 'numbers_array' || $option['type'] == 'gallery' ){
            $value = explode( ',', $_POST[$option['id']] );
            $value = array_filter($value);
            $newoptions[$option['id']] = $value;
          }elseif( in_array( $option['type'], array('open','close','title') ) ){
            continue;
          }else{
            $value = htmlspecialchars($_POST[$option['id']], ENT_QUOTES,"UTF-8");
            $newoptions[$option['id']] = $value;
          }
        }
        
        if ( $this->old_value != $newoptions ) {
          if( $this->is_network ){
            update_site_option( $this->saved_optionname, $newoptions );
          }else{
            update_option( $this->saved_optionname, $newoptions );
          }
        }
        
      }
      
      do_action('ashuwp_custom_saved');
      
    }
   
  }
}